/*******************************************************
Filename		:  gen_tblstrg.sql
Release 		:  C2.0.3
SIR			:  
Description		:  creates set_tblstrg.sql file and runs to set tables storage parameters.
Author			:  Ganesh Thadkamalla
Date			:  7/27/2004.
Comments		:  Run this script at the end of all ETL scripts.
**********************************************************/
set pagesize 1000
set heading off
set linesize 200
set trimspool on
set echo off
set feedback off

spool set_tblstrg.sql
prompt set feedback on
prompt set echo on

prompt spool set_tblstrg.log

SELECT 'ALTER TABLE STORETW.'||TABLE_NAME||' PCTFREE 0 PCTUSED 90;'
FROM USER_TABLES;

PROMPT --Atler Statements for PCTINCREASE are generated only if the tablespace extent management is dictionary.
SELECT 'ALTER TABLE STORETW.'||TABLE_NAME||' STORAGE (PCTINCREASE 0);'
FROM USER_TABLES
where exists (select 'x' from user_tablespaces
               where tablespace_name = 'STORETDATA'
                and extent_management='DICTIONARY');

prompt spool off;
spool off;

@set_tblstrg.sql

spool post_set_tblstrg.log

select table_name,pct_free, pct_used, pct_increase
from user_tables
where pct_free !=0
or pct_used !=90
or (pct_increase !=0 and pct_increase is not null);

spool off;

set pagesize 50;
set heading on;
set linesize 80;
set trimspool on;
set feedback on;